
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/robecharacter.zip" ),
}
local prefabs = {
	"robewand",
}

local start_inv = {
	"robewand",
}

local function sanityfn(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	
	local ground = GetWorld()
	local tile = GROUND.GRASS
	if ground and ground.Map then
		tile = ground.Map:GetTileAtPoint(x, y, z)
	end

	local onWater = ground.Map:IsWater(tile)

	local delta = 0
	if onWater then
		delta = TUNING.WOODLEGS_WATER_SANITY
	end
	
	return delta
end

local fn = function(inst)

	inst.soundsname = "wendy"
	inst:AddTag("painter")
	
	inst.MiniMapEntity:SetIcon( "robecharacter.tex" )

	inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	inst.components.sanity.custom_rate_fn = sanityfn
	
    inst.components.combat.damagemultiplier = .8
	
	inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 1.1

	inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED * 1.2
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.2
end

return MakePlayerCharacter("robecharacter", prefabs, assets, fn, start_inv)
